package jp.mosp.common.part;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import jp.mosp.common.CommonConst;

import jp.mosp.common.common.MospUtility;

/**
 * tɊւPartNX
 * @author yoshida
 * @version		0.0.4
 */
public class DatePart {

	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public static int getMonthRemainder(Date date1, Date date2) {
		int year1  = MospUtility.getYear (date1);
		int month1 = MospUtility.getMonth(date1);
		int year2  = MospUtility.getYear (date2);
		int month2 = MospUtility.getMonth(date2);
		int remainder = year1 * 12 + month1 - year2 * 12 - month2;
		return remainder;
	}

	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public static long getDateRemainder(Date date1, Date date2) {
		long remainder = date1.getTime() - date2.getTime();
		return (remainder / (1000 * 60 * 60 * 24)) + 1;
	}

	/**
	 * N
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static Date addYear(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.YEAR, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static Date addMonth(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.MONTH, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static Date addDay(Date date, String amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, Integer.parseInt(amount));
		return cal.getTime();
	}

	/**
	 * t擾iStringj
	 * @return tl
	 */
	public static Date getInitialDate() { 
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date(0));
		return cal.getTime();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public static Date getSystemDate() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public static Date getNowDate() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public static Date getFirstDateOfMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year));
		cal.set(Calendar.MONTH, Integer.parseInt(month) - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public static Date getFirstDateOfMonth(int year, int month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param date		Ώ۔N
	 * @return 
	 */
	public static Date getFirstDateOfMonth(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public static Date getLastDateOfMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year));
		cal.set(Calendar.MONTH, Integer.parseInt(month));
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public static Date getLastDateOfMonth(int year, int month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param date		Ώ۔N
	 * @return			ŏI
	 */
	public static Date getLastDateOfMonth(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.roll(Calendar.MONTH, 1);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  擾Ώ۔N
	 * @return 
	 */
	public static Date getFirstDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  擾Ώ۔N
	 * @return 
	 */
	public static Date getFirstDateOfYear(String year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year));
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  擾Ώ۔N
	 * @return ŏI
	 */
	public static Date getLastDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year + 1);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  擾Ώ۔N
	 * @return ŏI
	 */
	public static Date getLastDateOfYear(String year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year) + 1);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param date		Ώ۔N
	 * @return 
	 */
	public static Date getFirstDateOfYear(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param date		Ώ۔N
	 * @return			ŏI
	 */
	public static Date getLastDateOfYear(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.roll(Calendar.YEAR, 1);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  N
	 * @param month 
	 * @return N
	 */
	public static Date getYearMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year), Integer.parseInt(month) -1, 1, 0, 0, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  N
	 * @param month 
	 * @return N
	 */
	public static Date getYearMonth(int year, int month) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month -1, 1, 0, 0, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * Ԏ擾
	 * @param time 
	 * @return t
	 * @throws ParseException 
	 */
	public static Date getTimeAsDate(String time) {
		Date date = null;
		try {
			date = DateFormat.getTimeInstance(DateFormat.SHORT).parse(time);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.YEAR, CommonConst.TIME_DEFAULT_YEAR);
		cal.set(Calendar.MONTH, CommonConst.TIME_DEFAULT_MONTH);
		cal.set(Calendar.DAY_OF_MONTH, CommonConst.TIME_DEFAULT_DAY);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * I܂ވTԂ̊Jn擾
	 * @param date			I
	 * @param dayofweek		Jnji{@link Calender}̗jvaluej
	 * @return I܂ވTԂ̊Jn
	 */
	public static Date getFirstDateOfWeek(Date date, int dayofweek) {
		Calendar cal = Calendar.getInstance();
		cal.setFirstDayOfWeek(dayofweek);
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_WEEK, cal.getFirstDayOfWeek());
		return cal.getTime();
	}

	/**
	 * I܂ވTԂ̏I擾
	 * @param date			I
	 * @param dayofweek		Jnji{@link Calender}̗jvaluej
	 * @return I܂ވTԂ̏I
	 */
	public static Date getLastDateOfWeek(Date date, int dayofweek) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(getFirstDateOfWeek(date, dayofweek));
		cal.add(Calendar.DATE, 6);
		return cal.getTime();
	}

	/**
	 * tϊ(intString[])
	 * @param date Ώۓt
	 * @return tz
	 */
	public static String[] convIntegerDateToArray(int date) {
		String[] arDate = new String[3];
		if (date > 19000101) {
			String strDate = String.valueOf(date);
			arDate[0] = strDate.substring(0, 4);
			arDate[1] = StringPart.removeZero(strDate.substring(4, 6));
			arDate[2] = StringPart.removeZero(strDate.substring(6, 8));
		} else {
			arDate[0] = "1900";
			arDate[1] = "01";
			arDate[2] = "01";
		}
		return arDate;
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt(yyyyMMdd)
	 * @return yyyyNMMdd
	 */
	public static String convIntegerDateToJPDate(int date) {
		return convDateToFormatDateJP(convIntegerDateToDate(date));
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt(yyyyMMdd)
	 * @return yyyy/MM/dd
	 */
	public static String convIntegerDateToStringFormatted(int date) {
		return convDateFormatted(convIntegerDateToDate(date));
	}

	/**
	 * tϊ(Stringint)
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return yyyyMMdd
	 */
	public static int convStringDateToInteger(String year, String month, String day) {
		return NumberPart.getIntParam(convDateToString(getDate(year, month, day)));
	}

	/**
	 * tϊ(Stringint)
	 * @param 	yyyymmdd yyyy-MM-dd
	 * @return yyyyMMdd
	 */
	public static int convStringDateToInteger(String yyyymmdd) {
		return NumberPart.getIntParam(convDateToString(convHyphenDateToDate(yyyymmdd)));		
	}

	/**
	 * tϊ(intString)
	 * @param yyyy
	 * @param mm
	 * @param dd
	 * @return	tiyyyyMMddj
	 */
	public static String convIntegerToStringDate(int year, int month, int day) {
		return convDateToString(getDate(year, month, day));
	}

	/**
	 * tϊ(Dateint)
	 * @param date
	 * @return yyyyMMdd
	 */
	public static int convDateToInteger(Date date) {
		return NumberPart.getIntParam(convDateToString(date));
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyyMMdd
	 */
	public static String convDateToString(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_BASE);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-MM
	 */
	public static String convDateToStringYearMonth(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_YEAR_MONTH);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-m
	 */
	public static String convDateToStringYearMonthShort(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_YEAR_MONTH_SHORT);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-MM-dd
	 */
	public static String convDateFormattedByHyphen(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_HYPHEN);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy/MM/dd
	 */
	public static String convDateFormatted(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy,MM,dd
	 */
	public static String convDateFormattedByComma(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_COMMA);
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMMdd
	 */
	public static String convDateToFormatDateJP(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP);
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMd
	 */
	public static String convDateToFormatDateJPShort(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP_SHORT);
	}

	/**
	 * tϊ(StringString)
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return yyyy/MM/dd
	 */
	public static String convStringDateFormatted(String year, String month, String day) {
		return convDateFormatted(getDate(year, month, day));
	}

	/**
	 * tϊ(StringString)
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return yyyy,mm,dd
	 */
	public static String convStringDateFormattedByComma(String year, String month, String day) {
		return convDateFormattedByComma(getDate(year, month, day));
	}

	/**
	 * tϊ(StringString)
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return yyyy-MM-dd
	 */
	public static String convStringDateFormattedByHyphen(String year, String month, String day) {
		return convDateFormattedByHyphen(getDate(year, month, day));
	}

	/**
	 * tϊ(intString)
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return yyyy-MM-dd
	 */
	public static String convDateFormattedByHyphen(int year, int month, int day) {
		return convDateFormattedByHyphen(getDate(year, month, day));
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy/MM/dd
	 * @return date
	 */
	public static Date convStringDateToDate(String yyyymmdd) {
		return convFormatToDate(yyyymmdd, CommonConst.FORMAT_DATE);
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd yyyyMMdd
	 * @return date
	 */
	public static Date convStringBaseDateToDate(String yyyymmdd) {
		return convFormatToDate(yyyymmdd, CommonConst.FORMAT_DATE_BASE);
	}

	/**
	 * tϊ(StringString[])
	 * @param yyyymmdd Ώۓt(yyyy/mm/dd)
	 * @return tz
	 */
	public static String[] convStringDateToArray(String yyyymmdd) {
		String[] arDate = new String[3];
		if (yyyymmdd.equals("")) {
			for (int i = 0; i < 3; i++) {
				arDate[i] = "";
			}
		} else {
			arDate[0] = StringPart.removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[0]);
			arDate[1] = StringPart.removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[1]);
			arDate[2] = StringPart.removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[2]);
		}
		return arDate;
	}

	/**
	 * tϊiintDatej
	 * @param yyyymmdd	yyyyMMdd
	 * @return date
	 */
	public static Date convIntegerDateToDate(int yyyymmdd) {
		return convFormatToDate(String.valueOf(yyyymmdd), CommonConst.FORMAT_DATE_BASE);
	}

	/**
	 * tϊ(intDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public static Date getDate(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month - 1, day);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime(); 
	}

	/**
	 * tϊ(StringDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public static Date getDate(String year, String month, String day) {
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime(); 
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy-MM-dd
	 * @return date
	 */
	public static Date convHyphenDateToDate(String yyyymmdd) {
		return convFormatToDate(yyyymmdd, CommonConst.FORMAT_DATE_HYPHEN);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-MM-dd
	 * @return yyyyNMd
	 */
	public static String convHyphenDateToJPShortDate(String yyyymmdd) {
		return convDateToFormatDateJPShort(convHyphenDateToDate(yyyymmdd));
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-MM-dd
	 * @return yyyyNMMdd
	 */
	public static String convHyphenDateToJPDate(String yyyymmdd) {
		return convDateToFormatDateJP(convHyphenDateToDate(yyyymmdd));
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-MM-dd
	 * @return yyyy/MM/dd
	 */
	public static String convHyphenDateToFormatted(String yyyymmdd) {
		return convDateFormatted(convHyphenDateToDate(yyyymmdd));
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy/MM/dd
	 * @return yyyy-MM-dd
	 */
	public static String convFormattedToHyphen(String yyyymmdd) {
		return convDateFormattedByHyphen(convStringDateToDate(yyyymmdd));
	}

	/**
	 * t擾iStringj
	 * @return	9999-99-99 00:00:00
	 */
	public static String getDateTime() { 
		StringBuffer datetime = new StringBuffer();
		SimpleDateFormat sdfymd = new SimpleDateFormat(CommonConst.FORMAT_DATE);
		SimpleDateFormat sdfhms = new SimpleDateFormat(CommonConst.FORMAT_TIME);
		datetime.append(sdfymd.format(getSystemDate()));
		datetime.append(" ");
		datetime.append(sdfhms.format(getSystemDate()));
		return datetime.toString();
	}

	/**
	 * t擾iStringj
	 * @param date
	 * @return 9999-99-99 99:99:99
	 */
	public static String getDateTime(Date date) { 
		StringBuffer datetime = new StringBuffer();
		SimpleDateFormat sdfymd = new SimpleDateFormat(CommonConst.FORMAT_DATE);
		SimpleDateFormat sdfhms = new SimpleDateFormat(CommonConst.FORMAT_TIME);
		datetime.append(sdfymd.format(date));
		datetime.append(" ");
		datetime.append(sdfhms.format(date));
		return datetime.toString();
	}

	/**
	 * Ԓf
	 * @param startDate		Jn
	 * @param endDate		I
	 * @param targetDate	Ώۓ
	 * @return
	 * <p>
	 * JnƏI̊ԂɑΏۓ݂ꍇtrueA<br>
	 * łȂꍇfalse
	 * </p>
	 */
	public static boolean inPeriod(Date startDate, Date endDate, Date targetDate) {
		return targetDate.compareTo(startDate) >= 0 && targetDate.compareTo(endDate) <= 0;
	}

	/**
	 * tϊiStringDatej
	 * @since	0.0.2
	 * @param date		Ώ۔N
	 * @param format	ttH[}bg
	 * @return			Date^Ώ۔N
	 */
	public static Date convFormatToDate(String date, String format) {
		DateFormat df = new SimpleDateFormat(format);
		try {
			return df.parse(date);
		} catch (ParseException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * Ώ۔NxJn擾
	 * @since	0.0.3
	 * @param fiscalyear		Ώ۔Nx
	 * @param startMonth		NxJn
	 * @return	Ώ۔NxJn
	 */
	public static Date getFiscalStartDate(int fiscalyear, int startMonth) {
		return getFirstDateOfMonth(fiscalyear, startMonth);
	}

	/**
	 * Ώ۔NxIN擾
	 * @since	0.0.3
	 * @param fiscalyear		Ώ۔Nx
	 * @param startMonth		NxJn
	 * @return	Ώ۔NxIN
	 */
	public static Date getFiscalEndDate(int fiscalyear, int startMonth) {
		return getLastDateOfMonth(fiscalyear +1, startMonth -1);
	}

	/**
	 * T
	 * @since	0.0.4
	 * @param targetDate	Ώ۔N
	 * @param amount		T
	 * @return	t
	 */
	public static Date addWeek(Date targetDate, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.add(Calendar.WEEK_OF_MONTH, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @since	0.0.4
	 * @param targetDate	Ώ۔N
	 * @param hour			Ώێ
	 * @param min			Ώە
	 * @return	t
	 */
	public static Date getTimeOfDate(Date targetDate, int hour, int min) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, hour);
		cal.set(Calendar.MINUTE, min);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * j
	 * @since	0.0.4
	 * @param targetDate	Ώ۔N
	 * @param dayofweek		ύXji{@link Calender}̗jvaluej
	 * @return	t
	 */
	public static Date getDayOfWeek(Date targetDate, int dayofweek) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.DAY_OF_WEEK, dayofweek);
		return cal.getTime();
	}

}
